/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.button;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.events.GuiInitCompletedEvent;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.button.ButtonData;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.konkrete.gui.screens.SimpleLoadingScreen;
import de.keksuccino.konkrete.localization.LocaleUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.reflection.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.VideoSettingsScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ButtonCache {
    private static Map<Long, ButtonData> buttons = new HashMap<Long, ButtonData>();
    private static Map<Long, Widget> replaced = new HashMap<Long, Widget>();
    private static Screen current = null;
    private static boolean cached = false;
    private static boolean caching = false;

    @SubscribeEvent
    public void updateCache(GuiScreenEvent.InitGuiEvent.Post e) {
        if (!caching) {
            cached = false;
            current = e.getGui();
        }
    }

    @SubscribeEvent
    public void onInitCompleted(GuiInitCompletedEvent e) {
        ButtonCache.cache(e.getGui());
    }

    private static void cache(Screen s) {
        if (!cached) {
            cached = true;
            if (s instanceof LayoutEditorScreen) {
                return;
            }
            if (s instanceof SimpleLoadingScreen) {
                return;
            }
            if (!MenuCustomization.isMenuCustomizable(s)) {
                replaced.clear();
                buttons.clear();
                MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s != null && s instanceof VideoSettingsScreen && FancyMenu.isOptifineLoaded()) {
                replaced.clear();
                buttons.clear();
                MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s.getClass().getName().startsWith("slimeknights.")) {
                replaced.clear();
                buttons.clear();
                MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s.getClass().getName().startsWith("net.optifine")) {
                replaced.clear();
                buttons.clear();
                MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, new ArrayList<ButtonData>(), false));
                return;
            }
            if (s == Minecraft.func_71410_x().field_71462_r) {
                ButtonCache.updateButtons(s);
            }
            MinecraftForge.EVENT_BUS.post((Event)new ButtonCachedEvent(s, ButtonCache.getButtons(), true));
        }
    }

    private static void updateButtons(Screen s) {
        replaced.clear();
        buttons.clear();
        if (!MenuCustomization.isMenuCustomizable(s)) {
            return;
        }
        if (s != null && s instanceof VideoSettingsScreen && FancyMenu.isOptifineLoaded()) {
            return;
        }
        if (s.getClass().getName().startsWith("slimeknights.")) {
            return;
        }
        if (s.getClass().getName().startsWith("net.optifine")) {
            return;
        }
        List<ButtonData> ids = ButtonCache.cacheButtons(s, 1000, 1000);
        List<ButtonData> btns = ButtonCache.cacheButtons(s, Minecraft.func_71410_x().func_228018_at_().func_198107_o(), Minecraft.func_71410_x().func_228018_at_().func_198087_p());
        if (btns.size() == ids.size()) {
            int i = 0;
            for (ButtonData id : ids) {
                ButtonData button = btns.get(i);
                if (!buttons.containsKey(id.getId())) {
                    buttons.put(id.getId(), new ButtonData(button.getButton(), id.getId(), LocaleUtils.getKeyForString((String)button.getButton().func_230458_i_().getString()), s));
                } else if (((Boolean)FancyMenu.config.getOrDefault("showdebugwarnings", (Object)true)).booleanValue()) {
                    System.out.println("");
                    System.out.println("## WARNING [FANCYMENU]: Overlapping buttons found! ##");
                    System.out.println("At: X=" + button.x + " Y=" + button.y + "!");
                    System.out.println("Labels: " + button.label + ", " + ButtonCache.buttons.get((Object)Long.valueOf((long)id.getId())).label);
                    System.out.println("");
                    System.out.println("If one or both of these buttons are added by a mod, please contact the developer(s) to fix this!");
                    System.out.println("FancyMenu cannot customize overlapping buttons!");
                    System.out.println("#####################################################");
                    System.out.println("");
                }
                ++i;
            }
        }
    }

    private static List<ButtonData> cacheButtons(Screen s, int screenWidth, int screenHeight) {
        caching = true;
        ArrayList<ButtonData> buttonlist = new ArrayList<ButtonData>();
        try {
            Field f0 = ReflectionHelper.findField(Screen.class, (String)"field_230710_m_");
            f0.set(s, new ArrayList());
            Field f1 = ReflectionHelper.findField(Screen.class, (String)"field_230707_j_");
            f1.set(s, Minecraft.func_71410_x().func_175599_af());
            Field f2 = ReflectionHelper.findField(Screen.class, (String)"field_230712_o_");
            f2.set(s, Minecraft.func_71410_x().field_71466_p);
            s.func_231158_b_(Minecraft.func_71410_x(), screenWidth, screenHeight);
            Field f = ReflectionHelper.findField(Screen.class, (String)"field_230710_m_");
            for (Widget w : (List)f.get(s)) {
                String idRaw = w.field_230690_l_ + "" + w.field_230691_m_;
                long id = 0L;
                if (MathUtils.isLong((String)idRaw)) {
                    id = Long.parseLong(idRaw);
                }
                buttonlist.add(new ButtonData(w, id, LocaleUtils.getKeyForString((String)w.func_230458_i_().getString()), s));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        caching = false;
        return buttonlist;
    }

    public static void replaceButton(long id, Widget w) {
        ButtonData d = ButtonCache.getButtonForId(id);
        Widget ori = null;
        if (d != null && current != null) {
            try {
                Field f = ObfuscationReflectionHelper.findField(Screen.class, (String)"field_230710_m_");
                List l = (List)f.get(current);
                ArrayList<Widget> l2 = new ArrayList<Widget>();
                for (Widget b : l) {
                    if (b == d.getButton()) {
                        l2.add(w);
                        ori = b;
                        continue;
                    }
                    l2.add(b);
                }
                f.set(current, l2);
                if (ori != null) {
                    replaced.put(d.getId(), ori);
                }
                d.replaceButton(w);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void replaceButton(String key, Widget w) {
        ButtonData d = ButtonCache.getButtonForKey(key);
        if (d != null) {
            ButtonCache.replaceButton(d.getId(), w);
        }
    }

    public static void cacheFrom(Screen s, int screenWidth, int screenHeight) {
        ButtonCache.updateButtons(s);
    }

    public static long getIdForButton(Widget w) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (m.getValue().getButton() != w) continue;
            return m.getValue().getId();
        }
        return -1L;
    }

    public static String getNameForButton(Widget w) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (m.getValue().getButton() != w) continue;
            return m.getValue().label;
        }
        return null;
    }

    public static String getKeyForButton(Widget w) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (m.getValue().getButton() != w) continue;
            return m.getValue().getKey();
        }
        return null;
    }

    public static ButtonData getButtonForId(long id) {
        return buttons.get(id);
    }

    public static ButtonData getButtonForKey(String key) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (!m.getValue().getKey().equalsIgnoreCase(key)) continue;
            return m.getValue();
        }
        return null;
    }

    public static ButtonData getButtonForName(String name) {
        for (Map.Entry<Long, ButtonData> m : buttons.entrySet()) {
            if (!m.getValue().label.equals(name)) continue;
            return m.getValue();
        }
        return null;
    }

    public static List<ButtonData> getButtons() {
        ArrayList<ButtonData> b = new ArrayList<ButtonData>();
        b.addAll(buttons.values());
        return b;
    }

    public static boolean isCaching() {
        return caching;
    }
}

